/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpCommon;

import ibm.nways.analysis.dpCommon.DataPoint;
import ibm.nways.analysis.dpCommon.GraphDataSeriesImpl;
import ibm.nways.analysis.dpCommon.PollingObjectInstance;
import ibm.nways.analysis.dpManager.DpmClientApplet;
import ibm.nways.nhm.eui.NhmChart;
import ibm.nways.nhm.eui.NhmViewPage;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Observable;
import java.util.TimeZone;
import java.util.Vector;
import jclass.bwt.JCSerializable;
import jclass.chart.ChartDataModelUpdate;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.ChartText;
import jclass.chart.Chartable;
import jclass.chart.EventTrigger;
import jclass.chart.JCAxis;
import jclass.chart.JCAxisTitle;
import jclass.chart.JCBarChartFormat;
import jclass.chart.JCChart;
import jclass.chart.JCChartArea;
import jclass.chart.JCChartStyle;
import jclass.chart.JCChartTimeUtil;
import jclass.chart.JCDataIndex;
import jclass.chart.JCLabelGenerator;
import jclass.chart.JCLegend;
import jclass.chart.JCPickEvent;
import jclass.chart.JCPickListener;
import jclass.chart.JCPieChartFormat;
import jclass.chart.JCTitle;

public class GraphInstance
extends Observable
implements Serializable,
Chartable,
JCPickListener,
JCLabelGenerator {
    public static final int GRAPH_MODE_NONE = -1;
    public static final int GRAPH_MODE_HISTORY = 0;
    public static final int GRAPH_MODE_POINT = 1;
    public static final int GRAPH_MODE_SUMMARY = 2;
    public static final int MAXIMUM_SERIES_TO_SHOW = 10;
    private static final Color otherColor = Color.white;
    private static final Color[] colors = new Color[]{Color.blue, Color.red, Color.green, Color.yellow, Color.magenta, Color.orange, Color.pink, Color.cyan, Color.lightGray, Color.gray};
    private static final int[] shapes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    JCChart chart;
    private int graphType;
    private String graphName;
    private String units;
    private boolean graphIsReadyForUpdate = false;
    private static DateFormat df;
    private int numberOfPoints;
    private long periodEndingMillis = 0L;
    private long graphRangeMillis = 0L;
    private int mode = -1;
    private Date selectedDate;
    private Vector pois;
    private Vector graphDataSeries;
    private Date timeBase;

    public GraphInstance(String string, int n, String string2) {
        this.graphType = n;
        this.graphName = string;
        if (string2 != null) {
            this.units = string2;
        }
        this.pois = new Vector();
        this.graphDataSeries = new Vector();
        this.chart = new NhmChart();
        this.chart.getHeader().setIsShowing(true);
        this.chart.getHeader().getLabel().setText(string);
        this.chart.getLegend().setIsShowing(true);
        this.chart.getLegend().setAnchor(32);
        this.chart.setTrigger(0, new EventTrigger(0, 4));
        this.chart.setTrigger(1, new EventTrigger(1, 1));
        this.chart.setTrigger(2, new EventTrigger(8, 0));
        this.chart.setTrigger(3, new EventTrigger(2, 2));
        this.chart.getChartArea().setElevation(30);
        this.chart.getChartArea().setDepth(20);
        this.chart.getChartArea().setRotation(20);
        this.chart.getChartArea().setFastAction(true);
        this.chart.addPickListener(this);
    }

    public void setGraphMode(int n, Date date) {
        ChartDataView chartDataView = this.chart.getDataView(0);
        String string = this.graphName;
        if (this.mode != n) {
            if (n == 1) {
                if (date == null) {
                    date = this.getLatestDate();
                }
                string = string.concat(" (" + JCChartTimeUtil.timeLabel("%c", date) + ")");
                this.chart.getHeader().getLabel().setText(string, false);
            } else {
                this.chart.getHeader().getLabel().setText(string, false);
            }
        }
        if (n == 1) {
            JCAxis jCAxis = chartDataView.getXAxis();
            jCAxis.setAnnotationMethod(3);
        } else {
            JCAxis jCAxis = chartDataView.getXAxis();
            jCAxis.setTimeUnit(1000L);
            jCAxis.setTimeBase(this.timeBase);
            jCAxis.setAnnotationMethod(2);
            jCAxis.setTimeFormat("%c");
        }
        this.mode = n;
        this.chart.reset();
        this.graphUpdateAll();
    }

    public void setGraphRange() {
        ChartDataViewSeries[] chartDataViewSeriesArray;
        ChartDataView chartDataView = this.chart.getDataView(0);
        if (chartDataView != null && (chartDataViewSeriesArray = chartDataView.getSeries()) != null) {
            int n = 0;
            while (n < chartDataViewSeriesArray.length) {
                chartDataViewSeriesArray[n].setFirstPoint(0);
                chartDataViewSeriesArray[n].setLastPointIsDefault(true);
                ++n;
            }
        }
    }

    public void setGraphRange(double d) {
        ChartDataViewSeries[] chartDataViewSeriesArray;
        ChartDataView chartDataView = this.chart.getDataView(0);
        if (chartDataView != null && (chartDataViewSeriesArray = chartDataView.getSeries()) != null && chartDataViewSeriesArray.length > 0) {
            int n = chartDataViewSeriesArray[0].getX(d);
            int n2 = 0;
            while (n2 < chartDataViewSeriesArray.length) {
                chartDataViewSeriesArray[n2].setFirstPoint(n);
                chartDataViewSeriesArray[n2].setLastPointIsDefault(false);
                chartDataViewSeriesArray[n2].setLastPoint(n);
                ++n2;
            }
        }
    }

    public void setNumGraphPoints(int n) {
        this.graphRangeMillis = 0L;
        this.numberOfPoints = n;
    }

    public int getNumGraphPoints() {
        return this.numberOfPoints;
    }

    public void setChartType(int n) {
        int n2 = 0;
        ChartDataView chartDataView = this.chart.getDataView(0);
        JCBarChartFormat jCBarChartFormat = chartDataView.getBarChartFormat();
        this.chart.setIsBatched(true);
        switch (n) {
            case 0: {
                n2 = 0;
                jCBarChartFormat.set100Percent(false);
                chartDataView.setChartType(0);
                break;
            }
            case 10: {
                n2 = 0;
                jCBarChartFormat.set100Percent(false);
                chartDataView.setChartType(10);
                break;
            }
            case -1: {
                n2 = 0;
                jCBarChartFormat.set100Percent(true);
                chartDataView.setChartType(10);
                break;
            }
            case 9: {
                n2 = 1;
                jCBarChartFormat.set100Percent(false);
                chartDataView.setChartType(9);
                break;
            }
            case 11: {
                n2 = 1;
                jCBarChartFormat.set100Percent(false);
                chartDataView.setChartType(11);
                break;
            }
        }
        this.setGraphMode(n2, this.selectedDate);
        if (chartDataView != null) {
            chartDataView.setChanged(true);
        }
        this.chart.setIsBatched(false);
    }

    public void setGraphRange(long l, long l2) {
        this.numberOfPoints = 0;
        if (l == 0L) {
            this.graphRangeMillis = 0L;
            return;
        }
        this.periodEndingMillis = l2;
        this.graphRangeMillis = l;
    }

    public long getGraphRangeMillis() {
        return this.graphRangeMillis;
    }

    public long getPeriodEndingMillis() {
        return this.periodEndingMillis;
    }

    public void unregisterForEvents(DpmClientApplet dpmClientApplet) {
        Enumeration enumeration = this.graphDataSeries.elements();
        while (enumeration.hasMoreElements()) {
            GraphDataSeriesImpl graphDataSeriesImpl = (GraphDataSeriesImpl)enumeration.nextElement();
            graphDataSeriesImpl.unregisterForEvents(dpmClientApplet);
        }
    }

    public void registerForEvents(DpmClientApplet dpmClientApplet) {
        Enumeration enumeration = this.graphDataSeries.elements();
        while (enumeration.hasMoreElements()) {
            GraphDataSeriesImpl graphDataSeriesImpl = (GraphDataSeriesImpl)enumeration.nextElement();
            graphDataSeriesImpl.registerForEvents(dpmClientApplet);
        }
    }

    public void setupGraphData(DpmClientApplet dpmClientApplet) {
        String string = null;
        long l = 0L;
        long l2 = System.currentTimeMillis();
        if (this.graphRangeMillis != 0L) {
            if (this.periodEndingMillis != 0L) {
                l2 -= this.periodEndingMillis;
            }
            l = l2 - this.graphRangeMillis;
        }
        Date date = new Date(l);
        Date date2 = new Date(l2);
        Enumeration enumeration = this.pois.elements();
        while (enumeration.hasMoreElements()) {
            PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
            if (!pollingObjectInstance.getValidNonZeroData()) continue;
            String string2 = String.valueOf(pollingObjectInstance.getHostname()) + "." + pollingObjectInstance.getIdentifier();
            Vector vector = pollingObjectInstance.getHistory();
            if (vector.isEmpty()) continue;
            GraphDataSeriesImpl graphDataSeriesImpl = null;
            int n = vector.size();
            int n2 = n - this.numberOfPoints;
            Enumeration enumeration2 = vector.elements();
            int n3 = 0;
            while (enumeration2.hasMoreElements()) {
                Date date3;
                DataPoint dataPoint = (DataPoint)enumeration2.nextElement();
                if (graphDataSeriesImpl == null) {
                    string = dataPoint.getID();
                }
                if (this.units == null) {
                    this.units = "";
                }
                if (this.timeBase == null) {
                    this.timeBase = new Date(dataPoint.getDate());
                }
                if (graphDataSeriesImpl == null) {
                    graphDataSeriesImpl = new GraphDataSeriesImpl(string2, string, pollingObjectInstance, this, this.timeBase, this.chart.getDataView(0).getHoleValue());
                }
                if (!(date3 = new Date(dataPoint.getDate())).before(this.timeBase)) {
                    if (this.numberOfPoints != 0) {
                        if (n3 >= n2) {
                            graphDataSeriesImpl.addDataPoint(dataPoint);
                        }
                    } else if (!date3.before(date) && !date3.after(date2)) {
                        graphDataSeriesImpl.addDataPoint(dataPoint);
                    }
                }
                ++n3;
            }
            if (graphDataSeriesImpl == null) continue;
            graphDataSeriesImpl.registerForEvents(dpmClientApplet);
            this.graphDataSeries.addElement(graphDataSeriesImpl);
        }
    }

    public void setPollingObjectInstances(Vector vector) {
        this.pois = vector;
    }

    public void addPollingObjectInstances(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            PollingObjectInstance pollingObjectInstance = (PollingObjectInstance)enumeration.nextElement();
            this.pois.addElement(pollingObjectInstance);
        }
    }

    public int getGraphType() {
        return this.graphType;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Graph Instances:");
        stringBuffer.append("\n Polling Object Instances = " + this.pois);
        return stringBuffer.toString();
    }

    public void graphUpdateSeries(GraphDataSeriesImpl graphDataSeriesImpl) {
        int n = this.graphDataSeries.indexOf(graphDataSeriesImpl) * 2;
        int n2 = n + 1;
        this.notifyGraphOfChanges(n);
        this.notifyGraphOfChanges(n2);
    }

    public void graphUpdateSeries(GraphDataSeriesImpl graphDataSeriesImpl, int n) {
        int n2 = this.graphDataSeries.indexOf(graphDataSeriesImpl) * 2;
        int n3 = n2 + 1;
        this.notifyGraphOfChanges(n2, n);
        this.notifyGraphOfChanges(n3, n);
    }

    public synchronized void notifyGraphOfChanges(int n) {
        this.setChanged();
        this.notifyObservers(new ChartDataModelUpdate(3, n, 0));
        this.clearChanged();
    }

    public synchronized void notifyGraphOfChanges(int n, int n2) {
        this.setChanged();
        this.notifyObservers(new ChartDataModelUpdate(1, n, n2));
        this.clearChanged();
    }

    public synchronized void graphUpdateAll() {
        this.setChanged();
        this.notifyObservers(new ChartDataModelUpdate(12, 0, 0));
        this.clearChanged();
    }

    public static Color getUniqueColor(int n) {
        int n2 = n % colors.length;
        int n3 = n / colors.length;
        Color color = new Color(colors[n2].getRGB());
        int n4 = 0;
        while (n4 < n3) {
            color = color.darker();
            ++n4;
        }
        return color;
    }

    public static int getUniqueShape(int n) {
        int n2 = n / colors.length;
        int n3 = n + n2;
        int n4 = n3 % shapes.length;
        return shapes[n4];
    }

    public JCChart getGraph() {
        return this.getGraph(null);
    }

    public JCChart getGraph(Container container) {
        Serializable serializable;
        JCChartStyle jCChartStyle;
        JCSerializable jCSerializable;
        if (df == null) {
            df = DateFormat.getDateTimeInstance(1, 1);
            df.setTimeZone(TimeZone.getDefault());
        }
        ChartDataView chartDataView = this.chart.getDataView(0);
        chartDataView.setDataSource(this);
        this.setChartType(this.graphType);
        ChartDataViewSeries[] chartDataViewSeriesArray = chartDataView.getSeries();
        int n = 0;
        while (n < chartDataViewSeriesArray.length) {
            jCSerializable = chartDataViewSeriesArray[n];
            jCChartStyle = new JCChartStyle();
            serializable = GraphInstance.getUniqueColor(n);
            int n2 = GraphInstance.getUniqueShape(n);
            jCChartStyle.setLineColor((Color)serializable);
            jCChartStyle.setFillColor((Color)serializable);
            jCChartStyle.setSymbolShape(n2);
            jCChartStyle.setSymbolColor((Color)serializable);
            ((ChartDataViewSeries)jCSerializable).setStyle(jCChartStyle);
            ++n;
        }
        jCSerializable = chartDataView.getPieChartFormat();
        ((JCPieChartFormat)jCSerializable).setThresholdMethod(1);
        ((JCPieChartFormat)jCSerializable).setThresholdValue(0.0);
        ((JCPieChartFormat)jCSerializable).setMinSlices(10);
        jCChartStyle = new JCChartStyle();
        jCChartStyle.setFillColor(otherColor);
        ((JCPieChartFormat)jCSerializable).setOtherStyle(jCChartStyle);
        ((JCPieChartFormat)jCSerializable).setSortOrder(1);
        serializable = chartDataView.getYAxis();
        ((JCAxis)serializable).setTitle(new JCAxisTitle(this.units));
        ((JCAxis)serializable).getTitle().setRotation(3);
        ((JCAxis)serializable).getTitle().setPlacement(2);
        if (container != null) {
            JCTitle jCTitle = this.chart.getHeader();
            Font font = container.getFont();
            if (font != null) {
                Font font2 = new Font(font.getName(), 1, font.getSize());
                jCTitle.setFont(font2);
            }
        }
        return this.chart;
    }

    public void pick(JCPickEvent jCPickEvent) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        JCChart jCChart = null;
        JCDataIndex jCDataIndex = jCPickEvent.getPickResult();
        if (jCDataIndex != null) {
            Point[] pointArray;
            Point[] pointArray2;
            Serializable[] serializableArray;
            int n3;
            Object object = jCDataIndex.getObject();
            int n4 = jCDataIndex.getDistance();
            ChartDataView chartDataView = jCDataIndex.getDataView();
            JCPieChartFormat jCPieChartFormat = null;
            if (chartDataView != null) {
                jCPieChartFormat = chartDataView.getPieChartFormat();
            }
            ChartDataViewSeries chartDataViewSeries = jCDataIndex.getSeries();
            String string = null;
            GraphDataSeriesImpl graphDataSeriesImpl = null;
            if (chartDataViewSeries != null) {
                string = chartDataViewSeries.getName();
                graphDataSeriesImpl = this.getGraphDataSeries(string);
            }
            if ((n3 = jCDataIndex.getSeriesIndex()) == -10) {
                bl3 = true;
            }
            int n5 = jCDataIndex.getPoint();
            Component component = (Component)object;
            Container container = component.getParent();
            if (container instanceof JCChart) {
                jCChart = (JCChart)container;
            }
            if (object instanceof JCChartArea) {
                JCChartArea cfr_ignored_0 = (JCChartArea)object;
                if (n4 <= 5) {
                    if (chartDataView.getChartType() == 11 && chartDataView != null && n3 != -1) {
                        serializableArray = jCPieChartFormat.getExplodeList();
                        if (serializableArray != null) {
                            n = 0;
                            while (n < serializableArray.length) {
                                if (((Point)serializableArray[n]).x == n5 && ((Point)serializableArray[n]).y == n3) {
                                    pointArray2 = new Point[serializableArray.length - 1];
                                    n2 = 0;
                                    while (n2 < n) {
                                        pointArray2[n2] = serializableArray[n2];
                                        ++n2;
                                    }
                                    n2 = n;
                                    while (n2 < pointArray2.length) {
                                        pointArray2[n2] = serializableArray[n2 + 1];
                                        ++n2;
                                    }
                                    jCPieChartFormat.setExplodeList(pointArray2);
                                    bl = true;
                                    bl2 = true;
                                    break;
                                }
                                ++n;
                            }
                        }
                        if (!bl2) {
                            int n6 = 0;
                            if (serializableArray != null) {
                                n6 = serializableArray.length;
                            }
                            pointArray = new Point[n6 + 1];
                            n2 = 0;
                            while (n2 < n6) {
                                pointArray[n2] = serializableArray[n2];
                                ++n2;
                            }
                            pointArray[n6] = new Point(n5, n3);
                            jCPieChartFormat.setExplodeList(pointArray);
                            bl = true;
                        }
                    }
                    if (!bl3) {
                        Serializable serializable;
                        Object object2;
                        double d = chartDataViewSeries.getY(n5);
                        double d2 = 0.0;
                        long l = 0L;
                        Date date = null;
                        if (this.mode == 0) {
                            d2 = chartDataViewSeries.getX(n5);
                            l = (long)(d2 * 1000.0);
                            date = new Date(l + this.timeBase.getTime());
                        } else if (this.mode == 1) {
                            date = this.selectedDate != null ? this.selectedDate : this.getLatestDate();
                            l = date.getTime() - this.timeBase.getTime();
                            d2 = Math.round(l / 1000L);
                        }
                        double d3 = 0.0;
                        double d4 = 0.0;
                        ChartDataViewSeries[] chartDataViewSeriesArray = chartDataView.getSeries();
                        n = 0;
                        while (n < chartDataViewSeriesArray.length) {
                            int n7 = chartDataViewSeriesArray[n].getX(d2);
                            object2 = chartDataViewSeriesArray[n].getName();
                            serializable = this.getGraphDataSeries((String)object2);
                            if (this.mode == 0) {
                                n7 = chartDataViewSeriesArray[n].getX(d2);
                                ((GraphDataSeriesImpl)serializable).setSelected(n7);
                            } else if (this.mode == 1) {
                                n7 = 0;
                            }
                            double d5 = chartDataViewSeriesArray[n].getY(n7);
                            if (d5 != chartDataView.getHoleValue()) {
                                d4 += d5;
                            }
                            ++n;
                        }
                        if (d4 > 0.0) {
                            d3 = d / d4;
                        }
                        if (graphDataSeriesImpl != null) {
                            Applet applet = null;
                            object2 = component;
                            while (!(object2 instanceof Frame)) {
                                if (object2 instanceof Applet) {
                                    applet = (Applet)object2;
                                }
                                object2 = ((Component)object2).getParent();
                            }
                            serializable = (Frame)object2;
                            graphDataSeriesImpl.showDetails((Frame)serializable, d3, applet);
                            if (this.mode == 0) {
                                this.selectedDate = date;
                            }
                        }
                    }
                } else {
                    jCChart.reset();
                    bl = true;
                }
            } else if (object instanceof JCLegend) {
                if (jCChart != null) {
                    jCChart.setIsBatched(true);
                }
                if (chartDataViewSeries != null) {
                    chartDataViewSeries.setIsShowing(false);
                    chartDataViewSeries.setIsIncluded(false);
                } else if (chartDataView != null) {
                    serializableArray = chartDataView.getSeries();
                    n = 0;
                    while (n < serializableArray.length) {
                        if (!((ChartDataViewSeries)serializableArray[n]).getIsShowing()) {
                            ((ChartDataViewSeries)serializableArray[n]).setIsShowing(true);
                            ((ChartDataViewSeries)serializableArray[n]).setIsIncluded(true);
                        }
                        ++n;
                    }
                }
                if (jCChart != null) {
                    jCChart.setIsBatched(false);
                }
            }
            if (jCChart != null && (serializableArray = jCChart.getParent()) instanceof Panel && (pointArray2 = serializableArray.getParent()) instanceof NhmViewPage) {
                pointArray = pointArray2;
                pointArray.setCurrentComponent(jCChart);
            }
            if (chartDataView != null && bl) {
                chartDataView.setChanged(true);
            }
        }
    }

    public int getDataInterpretation() {
        return 1;
    }

    public Object getDataItem(int n, int n2) {
        Double d = null;
        GraphDataSeriesImpl graphDataSeriesImpl = null;
        try {
            graphDataSeriesImpl = (GraphDataSeriesImpl)this.graphDataSeries.elementAt(n / 2);
        }
        catch (Exception exception) {
            System.out.println("Exception in getDataItem for row " + n + " column " + n2);
            exception.printStackTrace();
        }
        if (graphDataSeriesImpl != null) {
            d = n % 2 == 0 ? (this.mode == 1 ? new Double(0.0) : graphDataSeriesImpl.getDate(n2)) : (this.mode == 1 ? graphDataSeriesImpl.getSelectedValue() : graphDataSeriesImpl.getValue(n2));
        }
        return d;
    }

    public synchronized Vector getRow(int n) {
        Vector<Double> vector = null;
        GraphDataSeriesImpl graphDataSeriesImpl = null;
        try {
            graphDataSeriesImpl = (GraphDataSeriesImpl)this.graphDataSeries.elementAt(n / 2);
        }
        catch (Exception exception) {
            System.out.println("Exception in getRow for row " + n);
            exception.printStackTrace();
        }
        if (graphDataSeriesImpl != null) {
            if (n % 2 == 0) {
                if (this.mode == 1) {
                    vector = new Vector<Double>();
                    vector.addElement(new Double(0.0));
                } else {
                    vector = graphDataSeriesImpl.getDates();
                }
            } else if (this.mode == 1) {
                vector = new Vector();
                vector.addElement(graphDataSeriesImpl.getSelectedValue());
            } else {
                vector = graphDataSeriesImpl.getValues();
            }
        }
        return vector;
    }

    public int getNumRows() {
        return this.graphDataSeries.size() * 2;
    }

    public String[] getPointLabels() {
        String[] stringArray = null;
        return stringArray;
    }

    public String getSeriesName(int n) {
        String string = "";
        GraphDataSeriesImpl graphDataSeriesImpl = (GraphDataSeriesImpl)this.graphDataSeries.elementAt(n);
        if (graphDataSeriesImpl != null) {
            string = graphDataSeriesImpl.getName();
        }
        return string;
    }

    public String getSeriesLabel(int n) {
        return this.getSeriesName(n);
    }

    public String getName() {
        return this.graphName;
    }

    public Object makeLabel(double d, int n) {
        ChartDataView chartDataView = this.chart.getDataView(0);
        JCAxis jCAxis = chartDataView.getXAxis();
        Date date = jCAxis.valueToDate(d);
        ChartText chartText = new ChartText();
        String string = df.format(date);
        chartText.setText(string);
        return chartText;
    }

    public GraphDataSeriesImpl getGraphDataSeries(String string) {
        GraphDataSeriesImpl graphDataSeriesImpl = null;
        Enumeration enumeration = this.graphDataSeries.elements();
        while (enumeration.hasMoreElements()) {
            GraphDataSeriesImpl graphDataSeriesImpl2 = (GraphDataSeriesImpl)enumeration.nextElement();
            if (!string.equals(graphDataSeriesImpl2.getName())) continue;
            graphDataSeriesImpl = graphDataSeriesImpl2;
        }
        return graphDataSeriesImpl;
    }

    public synchronized Date getLatestDate() {
        Date date = new Date();
        boolean bl = false;
        Enumeration enumeration = this.graphDataSeries.elements();
        while (enumeration.hasMoreElements()) {
            GraphDataSeriesImpl graphDataSeriesImpl = (GraphDataSeriesImpl)enumeration.nextElement();
            Date date2 = graphDataSeriesImpl.getLatestDateObject();
            if (bl && !date2.after(date)) continue;
            bl = true;
            date = date2;
        }
        return date;
    }

    public Vector getGraphDataSeries() {
        return this.graphDataSeries;
    }

    public String getGraphName() {
        return this.graphName;
    }

    public Vector getPollingObjectInstances() {
        return this.pois;
    }
}

